preset{end+1}.machine_name = 'ALBA';
preset{end}.pickup_name = 'Booster buttons';
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-alba-bo.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Concave';
preset{end}.electrode_amount = 4;
preset{end}.R = 14.5;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 7*[1 1 1 1]; 
preset{end}.ethick = 4*[1 1 1 1];  
preset{end}.gapback = 0.3*[1 1 1 1]; 
preset{end}.gapside = 0.3*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.09;
preset{end}.hmax = 0.8; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 


preset{end+1}.machine_name = 'ALBA';
preset{end}.pickup_name = 'Storage ring BPM'; 
preset{end}.pickup_comment = 'symmetric dummy'; 
preset{end}.model_saved = 'mesh-alba-sr-dummy.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [-20.412 -14; -36 -5; -36 5; -20.412 14; -12.85 14; -12.85 18.3; -5.25 18.3; -5.25 14; 5.25 14; 5.25 18.3; 12.85 18.3; 12.85 14; 20.412 14; 36 5; 36 -5; 20.412 -14; 12.85 -14; 12.85 -18.3; 5.25 -18.3; 5.25 -14; -5.25 -14; -5.25 -18.3; -12.83 -18.3; -12.83 -14; -20.412 -14]; 
preset{end}.elec(:,:,1) = [5.55 14;  5.55 18;  12.55 18;  12.55 14;  5.55 14]; 
preset{end}.elec(:,:,2) = [-5.55 14;  -5.55 18;  -12.55 18;  -12.55 14;  -5.55 14]; 
preset{end}.elec(:,:,3) = [-5.55 -14;  -5.55 -18;  -12.55 -18;  -12.55 -14;  -5.55 -14]; 
preset{end}.elec(:,:,4) = [5.55 -14;  5.55 -18;  12.55 -18;  12.55 -14;  5.55 -14]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 160; 
preset{end}.refinement = [false true false true]; 
preset{end}.hmin = 0.08; 
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 

preset{end+1}.machine_name = 'ALBA';
preset{end}.pickup_name = 'Storage ring BPM'; 
preset{end}.pickup_comment = 'Flange-1'; 
preset{end}.model_saved = 'mesh-alba-sr-flange1.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [-36,5; -20.412,14; -12.85,14; -12.85,18.3; -5.25,18.3; -5.25,14; 5.25,14; 5.25,18.3; 12.85,18.3; 12.85,14; 20.412,14; 36,5; 51,5; 51,-5; 36,-5; 20.412,-14; 12.85,-14; 12.85,-18.3; 5.25,-18.3; 5.25,-14; -5.25,-14; -5.25,-18.3; -12.85,-18.3; -12.85,-14; -20.412,-14; -36,-5; -36,5]; 
preset{end}.elec(:,:,1) = [5.55 14;  5.55 18;  12.55 18;  12.55 14;  5.55 14]; 
preset{end}.elec(:,:,2) = [-5.55 14;  -5.55 18;  -12.55 18;  -12.55 14;  -5.55 14]; 
preset{end}.elec(:,:,3) = [-5.55 -14;  -5.55 -18;  -12.55 -18;  -12.55 -14;  -5.55 -14]; 
preset{end}.elec(:,:,4) = [5.55 -14;  5.55 -18;  12.55 -18;  12.55 -14;  5.55 -14]; 
preset{end}.symmetry = '2-fold (H axis)'; 
preset{end}.mesh_gen_ttl = 500; 
preset{end}.refinement = [false true false true]; 
preset{end}.hmin = 0.08; % 0.06; 
preset{end}.hmax = 1; % 0.2; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 

preset{end+1}.machine_name = 'ALBA';
preset{end}.pickup_name = 'Storage ring BPM'; 
preset{end}.pickup_comment = 'Station-4'; 
preset{end}.model_saved = ''; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [-36,5; -20.412,14; -12.85,14; -12.85,18.3; -5.25,18.3; -5.25,14; 5.25,14; 5.25,18.3; 12.85,18.3; 12.85,14; 20.412,14; 36,5; 56,5; 89.588,14;160,14;160,-14;89.588,-14; 56,-5; 36,-5; 20.412,-14; 12.85,-14; 12.85,-18.3; 5.25,-18.3; 5.25,-14; -5.25,-14; -5.25,-18.3; -12.85,-18.3; -12.85,-14; -20.412,-14; -36,-5; -36,5]; 
preset{end}.elec(:,:,1) = [5.55 14;  5.55 18;  12.55 18;  12.55 14;  5.55 14]; 
preset{end}.elec(:,:,2) = [-5.55 14;  -5.55 18;  -12.55 18;  -12.55 14;  -5.55 14]; 
preset{end}.elec(:,:,3) = [-5.55 -14;  -5.55 -18;  -12.55 -18;  -12.55 -14;  -5.55 -14]; 
preset{end}.elec(:,:,4) = [5.55 -14;  5.55 -18;  12.55 -18;  12.55 -14;  5.55 -14]; 
preset{end}.symmetry = '2-fold (H axis)'; 
preset{end}.mesh_gen_ttl = 500; 
preset{end}.refinement = [false true false true]; 
preset{end}.hmin = 0.08; % 0.06; 
preset{end}.hmax = 1; % 0.2; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 

preset{end+1}.machine_name = 'ALBA 2';
preset{end}.pickup_name = 'Storage Ring BPM';
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-alba2-sr.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 8;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 4*[1 1 1 1]; 
preset{end}.ethick = 4*[1 1 1 1]; 
preset{end}.edist  = 8*[1 1 1 1]; 
preset{end}.gapback = 0.5*[1 1 1 1]; 
preset{end}.gapside = 0.2*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.015;
preset{end}.hmax = 0.5; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
% preset{end}.kx_ky = {[], [], [], [11.469, 14.37]};
% preset{end}.roi_dos_xy = [1 1];
preset{end}.step_dos_xy = 0.5; 


preset{end+1}.machine_name = 'ESRF';
preset{end}.pickup_name = 'Standard SR BPM'; 
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-esrf-srstd.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [35.5 -8.5; 35.5 8.5; 16.5 16.5; 15.5 16.5; 15.5 22.5; 4.5 22.5; 4.5 16.5; -4.5 16.5; -4.5 22.5; -15.5 22.5; -15.5 16.5; -16.5 16.5; -43.5 6.5; -43.5 -6.5; -16.6 -16.5;...
    -15.5 -16.5; -15.5 -22.5; -4.5 -22.5; -4.5 -16.5; 4.5 -16.5; 4.5 -22.5; 15.5 -22.5; 15.5 -16.5; 16.5 -16.5; 35.5 -8.5]; 
preset{end}.elec(:,:,1) = [15.25 16.5; 15.25 20.5; 4.75 20.5; 4.75 16.5; 15.25 16.5]; 
preset{end}.elec(:,:,2) = [-15.25 16.5; -15.25 20.5; -4.75 20.5; -4.75 16.5; -15.25 16.5]; 
preset{end}.elec(:,:,3) = [-15.25 -16.5; -15.25 -20.5; -4.75 -20.5; -4.75 -16.5; -15.25 -16.5]; 
preset{end}.elec(:,:,4) = [15.25 -16.5; 15.25 -20.5; 4.75 -20.5; 4.75 -16.5; 15.25 -16.5]; 
preset{end}.symmetry = '2-fold (H axis)'; 
preset{end}.mesh_gen_ttl = 700; 
preset{end}.refinement = [false true false true]; 
preset{end}.hmin = 0.05; 
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'atanh_ESRF'}; 
preset{end}.kx_ky = {[], [], [], [11.469, 14.37]};
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [20 14];
preset{end}.roi_poly_sum_xy = [20 14];
preset{end}.roi_poly_Q_xy = [20 14];

preset{end+1}.machine_name = 'ESRF';
preset{end}.pickup_name = 'Small EBS-BPM';
preset{end}.pickup_comment = '6 mm buttons'; 
preset{end}.model_saved = 'mesh-esrf-bpm6.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [...
            25	3
            10.12989	3
            9.1955	3.435713
            11.097282	7.514098
            5.206282	10.261117
            3.3045	6.182732
            2.624116	6.5
            -2.624116	6.5
            -3.3045	6.182732
            -5.206282	10.261117
            -11.097282	7.514098
            -9.1955	3.435713
            -10.12989	3
            -25	3
            -25	-3
            -10.12989	-3
            -9.1955	-3.435713
            -11.097282	-7.514098
            -5.206282	-10.261117
            -3.3045	-6.182732
            -2.624116	-6.5
            2.624116	-6.5
            3.3045	-6.182732
            5.206282	-10.261117
            11.097282	-7.514098
            9.1955	-3.435713
            10.12989	-3
            25	-3
            25	3]; 
preset{end}.elec(:,:,1) = [3.531077     6.077077; 5.221550     9.702309; 10.659396     7.166599; 8.968923     3.541368; 3.531077     6.077077]; 
preset{end}.elec(:,:,2) = [-3.531077     6.077077; -5.221550     9.702309; -10.659396     7.166599; -8.968923     3.541368; -3.531077     6.077077]; 
preset{end}.elec(:,:,3) = [-3.531077     -6.077077; -5.221550     -9.702309; -10.659396     -7.166599; -8.968923     -3.541368; -3.531077     -6.077077]; 
preset{end}.elec(:,:,4) = [3.531077     -6.077077; 5.221550     -9.702309; 10.659396     -7.166599; 8.968923     -3.541368; 3.531077     -6.077077]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 300; 
preset{end}.hmin = 0.06; 
preset{end}.hmax = 0.6; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [8 5];
preset{end}.roi_poly_sum_xy = [8 5];
preset{end}.roi_poly_Q_xy = [8 5];
preset{end}.poly_powers = [13 20 12];


preset{end+1}.machine_name = 'ESRF';
preset{end}.pickup_name = 'Large EBS-BPM';
preset{end}.pickup_comment = '8 mm buttons'; 
preset{end}.model_saved = 'mesh-esrf-bpm8.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [...
           25            3
           25           -3
       15.871           -3
       14.756      -3.9361
       17.648      -7.3833
       11.137      -12.847
       8.2443      -9.3998
        7.529          -10
       -7.529          -10
      -8.2443      -9.3998
      -11.137      -12.847
      -17.648      -7.3833
      -14.756      -3.9361
      -15.871           -3
          -25           -3
          -25            3
      -15.871            3
      -14.756       3.9361
      -17.648       7.3833
      -11.137       12.847
      -8.2443       9.3998
       -7.529           10
        7.529           10
       8.2443       9.3998
       11.137       12.847
       17.648       7.3833
       14.756       3.9361
       15.871            3
           25            3]; 
preset{end}.elec(:,:,1) = [8.435822	9.239096; 11.006973	12.303274; 17.135328	7.160973; 14.564178	4.096795; 8.435822	9.239096]; 
preset{end}.elec(:,:,2) = [-8.435822	9.239096; -11.006973	12.303274; -17.135328	7.160973; -14.564178	4.096795; -8.435822	9.239096]; 
preset{end}.elec(:,:,3) = [-8.435822	-9.239096; -11.006973	-12.303274; -17.135328	-7.160973; -14.564178	-4.096795; -8.435822	-9.239096]; 
preset{end}.elec(:,:,4) = [8.435822	-9.239096; 11.006973	-12.303274; 17.135328	-7.160973; 14.564178	-4.096795; 8.435822	-9.239096]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 300; 
preset{end}.hmin = 0.06; 
preset{end}.hmax = 0.6; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [9 6];
preset{end}.roi_poly_sum_xy = [9 6];
preset{end}.roi_poly_Q_xy = [9 6];


preset{end+1}.machine_name = 'ESRF';
preset{end}.pickup_name = 'EBS Chamber 12';
preset{end}.pickup_comment = '4x 6 mm buttons CC-FF'; 
preset{end}.model_saved = 'mesh-esrf-cham12-ccff.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [...
           25            3
           25           -3
       15.871           -3
        7.529          -10
        6.75 -10
        6.75 -14.25
        0.25 -14.25
        0.25 -10
        -0.25 -10
        -0.25 -14.25
        -6.75 -14.25
        -6.75 -10
       -7.529          -10
      -15.871           -3
          -25           -3
          -25            3
      -15.871            3
       -7.529           10
       -6.75 10
       -6.75 14.25
       -0.25 14.25
       -0.25 10
       0.25 10
       0.25 14.25
       6.75 14.25
       6.75 10
        7.529           10
       15.871            3
           25            3]; 
preset{end}.elec(:,:,1) = [0.5 10; 0.5 14; 6.5 14; 6.5 10; 0.5 10]; 
preset{end}.elec(:,:,2) = [-0.5 10; -0.5 14; -6.5 14; -6.5 10; -0.5 10]; 
preset{end}.elec(:,:,3) = [-0.5 -10; -0.5 -14; -6.5 -14; -6.5 -10; -0.5 -10]; 
preset{end}.elec(:,:,4) = [0.5 -10; 0.5 -14; 6.5 -14; 6.5 -10; 0.5 -10]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 300; 
preset{end}.hmin = 0.06; 
preset{end}.hmax = 0.6; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [9 6];
preset{end}.roi_poly_sum_xy = [9 6];
preset{end}.roi_poly_Q_xy = [9 6];



preset{end+1}.machine_name = 'ESRF';
preset{end}.pickup_name = 'EBS Chamber 12';
preset{end}.pickup_comment = '2x 8 mm buttons BB-DD'; 
preset{end}.model_saved = 'mesh-esrf-cham12-bbdd.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 2;
preset{end}.body = [...
           25            3
           25           -3
       15.871           -3
        7.529          -10
        4.25 -10
        4.25 -14.25
        -4.25 -14.25
        -4.25 -10
       -7.529          -10
      -15.871           -3
          -25           -3
          -25            3
      -15.871            3
       -7.529           10
       -4.25 10
       -4.25 14.25
       4.25 14.25
       4.25 10
        7.529           10
       15.871            3
           25            3]; 
preset{end}.elec(:,:,1) = [-4 10; -4 14; 4 14; 4 10; -4 10]; 
preset{end}.elec(:,:,2) = [-4 -10; -4 -14; 4 -14; 4 -10; -4 -10]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 300; 
preset{end}.hmin = 0.06; 
preset{end}.hmax = 0.6; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [9 6];
preset{end}.roi_poly_sum_xy = [9 6];
preset{end}.roi_poly_Q_xy = [9 6];
preset{end}.electrode_pair = 'ver';


preset{end+1}.machine_name = 'KEKB-BT';
preset{end}.pickup_name = 'Stripline';
preset{end}.pickup_comment = '';
preset{end}.model_saved = 'mesh-kekb-stripline.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 33;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [45 135 225 315]; 
preset{end}.aspan_deg = 0*[1 1 1 1]; 
preset{end}.ewidth = [20.4  20.4 20.4 20.4]; 
preset{end}.ethick = [2 2 2 2]; 
preset{end}.edist  = 26*[1 1 1 1]; 
preset{end}.gapback = [0 0 0 0]; 
preset{end}.gapside = [0 0 0 0]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 1.5; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [1 1];
preset{end}.roi_poly_xy = [12 12];



% for all PETRA3 BPMs the button widths & gaps may not be correct
preset{end+1}.machine_name = 'PETRA3';
preset{end}.pickup_name = 'Alte Achtel und gerade Strecken';
preset{end}.pickup_comment = 'ellipse 80x40'; 
preset{end}.model_saved = 'mesh-petra3-aachtel.mat'; 
preset{end}.beampipe_type = 'Elliptic';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 40;
preset{end}.r = 20;
preset{end}.aorie_deg = [55 125 235 305]; 
preset{end}.ewidth = [11 11 11 11]; 
preset{end}.ethick = [2 2 2 2]; 
preset{end}.edist  = [0 0 0 0]; 
preset{end}.gapback = [0.5 0.5 0.5 0.5]; 
preset{end}.gapside = [0.5 0.5 0.5 0.5]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.09;
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'};


preset{end+1}.machine_name = 'PETRA3';
preset{end}.pickup_name = 'Gerade Strecken, E-Weg, L-Weg';
preset{end}.pickup_comment = 'circle x94'; 
preset{end}.model_saved = 'mesh-petra3-elweg-grosse.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 47;
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.ewidth = [15 15 15 15]; 
preset{end}.ethick = [2 2 2 2]; 
preset{end}.edist  = 47*[1 1 1 1]; 
preset{end}.gapback = [0.5 0.5 0.5 0.5]; 
preset{end}.gapside = [0.5 0.5 0.5 0.5]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.09;
preset{end}.hmax = 1.5; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 


preset{end+1}.machine_name = 'PETRA3';
preset{end}.pickup_name = 'E-Weg, L-Weg';
preset{end}.pickup_comment = 'circle x59.5'; 
preset{end}.model_saved = 'mesh-petra3-elweg-kleine.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 29.75;
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.ewidth = [11 11 11 11]; 
preset{end}.ethick = [2 2 2 2]; 
preset{end}.edist  = 29.75*[1 1 1 1]; 
preset{end}.gapback = [0.5 0.5 0.5 0.5]; 
preset{end}.gapside = [0.5 0.5 0.5 0.5]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.9;
preset{end}.hmax = 1.5; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 


preset{end+1}.machine_name = 'PETRA3';
preset{end}.pickup_name = 'E-Weg';
preset{end}.pickup_comment = 'ellipse 45.5x25'; 
preset{end}.model_saved = 'mesh-petra3-eweg.mat'; 
preset{end}.beampipe_type = 'Elliptic';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 22.75;
preset{end}.r = 12.5;
preset{end}.aorie_deg = [52.5 180-52.5 180+52.5 360-52.5]; 
preset{end}.ewidth = [11 11 11 11]; 
preset{end}.ethick = [2 2 2 2]; 
preset{end}.edist  = [0 0 0 0]; 
preset{end}.gapback = [0.5 0.5 0.5 0.5]; 
preset{end}.gapside = [0.5 0.5 0.5 0.5]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.1;
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'};

preset{end+1}.machine_name = 'ELI-NP';
preset{end}.pickup_name = 'Linac stripline';
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-eli-linac.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 20;
preset{end}.input_by = 'angular span'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = 26 * [1 1 1 1];  %25.142 * [1 1 1 1]; 
preset{end}.ewidth = [0 0 0 0]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = [17 17 17 17]; 
preset{end}.gapback = [4.2 4.2 4.2 4.2]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.refinement = [false true false true]; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.16;
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.roi_poly_xy = [10 10];
preset{end}.roi_poly_sum_xy = [10 10];
preset{end}.roi_poly_Q_xy = [10 10];

preset{end+1}.machine_name = 'ELI-NP';
preset{end}.pickup_name = 'Dump stripline';
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-eli-dump.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 59;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [0 0 0 0]; 
preset{end}.ewidth = 29.9 * [1 1 1 1]; 
preset{end}.ethick = 1.5 * [1 1 1 1]; 
preset{end}.edist  = 50* [1 1 1 1]; 
preset{end}.gapback = [0 0 0 0]; 
preset{end}.gapside = [0 0 0 0]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.refinement = [false false false true]; 
preset{end}.hmin = 0.5;
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'};


preset{end+1}.machine_name = 'BESSY II';
preset{end}.pickup_name = 'button BPM'; 
preset{end}.pickup_comment = '20 years old'; 
preset{end}.model_saved = 'mesh-bessy2-old.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [-32.5 4.128421;-30.8 8.45858;-15.5 16.830127;-14.85 17.5;-14.85 20.861577;-3.45 20.861577;-3.45 17.5;3.45 17.5;3.45 20.861577;14.85 20.861577;14.85 ...
    17.5;15.5 16.830127;34.6 6.49147;36.5 1.819020;36.5 -1.819020;34.6 -6.49147;15.5 -16.830127;14.85 -17.5;14.85 -20.861577;3.45 -20.861577;3.45 -17.5;-3.45 -17.5;-3.45 ...
    -20.861577;-14.85 -20.861577;-14.85 -17.5;-15.5 -16.830127;-30.8 -8.45858;-32.5 -4.128421;-32.5 4.128421]; 
preset{end}.elec(:,:,1) = [14.55 17.5;14.55 20.1;3.75 20.1;3.75 17.5;14.55 17.5]; 
preset{end}.elec(:,:,2) = [-14.55 17.5;-14.55 20.1;-3.75 20.1;-3.75 17.5;-14.55 17.5]; 
preset{end}.elec(:,:,3) = [-14.55 -17.5;-14.55 -20.1;-3.75 -20.1;-3.75 -17.5;-14.55 -17.5]; 
preset{end}.elec(:,:,4) = [14.55 -17.5;14.55 -20.1;3.75 -20.1;3.75 -17.5;14.55 -17.5]; 
preset{end}.symmetry = '2-fold (H axis)'; 
preset{end}.mesh_gen_ttl = 500; 
preset{end}.refinement = [false true false true]; 
preset{end}.hmin = 0.09; 
preset{end}.hmax = 0.9; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.roi_poly_xy = [10 10];


preset{end+1}.machine_name = 'SESAME';
preset{end}.pickup_name = 'stripline'; 
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = 'mesh-sesame.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 75;
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.ewidth = 25*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 40*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 4; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 


preset{end+1}.machine_name = 'TESLA'; 
preset{end}.pickup_name = 'Coaxial stripline'; 
preset{end}.pickup_comment = 'inside poles of quads'; 
preset{end}.model_saved = 'mesh-tesla.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Circle';
preset{end}.electrode_amount = 4;
preset{end}.R = 10;
preset{end}.input_by = 'impedance'; % {'impedance', 'exterior radius'}
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.eradius_int = [1 1 1 1]; 
preset{end}.eradius_ext = 2.3*[1 1 1 1]; 
preset{end}.eimpedance = 50*[1 1 1 1];
preset{end}.edist = 10*[1 1 1 1]; 
preset{end}.symmetry = '4-fold';
preset{end}.hmin = 0.25; 
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMS stripline';
preset{end}.pickup_comment = 'D = 68.8mm'; 
preset{end}.model_saved = 'mesh-lhc-bpms.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 34.4;
preset{end}.input_by = 'angular span'; 
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.aspan_deg = 31.5*[1 1 1 1]; 
preset{end}.ewidth = [0 0 0 0]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 30.5*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.2;
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMSW stripline (around IPs)';
preset{end}.pickup_comment = 'nominal offset = 8mm, D = 68.8mm';
preset{end}.model_saved = 'mesh-lhc-bpmsw.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 34.4;
preset{end}.input_by = 'angular span'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = 31.5*[1 1 1 1]; 
preset{end}.ewidth = [0 0 0 0]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 30.5*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.2;
preset{end}.hmax = 1; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMSX stripline';
preset{end}.pickup_comment = 'D = 88.8mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmsx.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 44.4;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [0 0 0 0]; 
preset{end}.ewidth = 12.36*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 40.5*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 220; 
preset{end}.hmin = 0.2;
preset{end}.hmax = 2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMD stripline';
preset{end}.pickup_comment = 'dump straight section, D = 138.8mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmd.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 69.4;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [0 0 0 0]; 
preset{end}.ewidth = 12.15*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 65.5*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.hmin = 0.5;
preset{end}.hmax = 5; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMCS stripline';
preset{end}.pickup_comment = 'D = 56.8mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmcs.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 28.4;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [0 0 0 0]; 
preset{end}.ewidth = 12.15*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 24.5*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.hmin = 0.5;
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMWI buttons';
preset{end}.pickup_comment = 'arc large, D = 80mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmwi.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Concave';
preset{end}.electrode_amount = 4;
preset{end}.R = 40;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = 2.5*[1 1 1 1]; 
preset{end}.gapback = 7.4*[1 1 1 1]; 
preset{end}.gapside = 0.5*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.2;
preset{end}.hmax = 2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMW buttons';
preset{end}.pickup_comment = 'arc medium, D = 61mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmw.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Concave';
preset{end}.electrode_amount = 4;
preset{end}.R = 30.5;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = 3*[1 1 1 1]; 
preset{end}.gapback = 3.75*[1 1 1 1]; 
preset{end}.gapside = 0.7*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.2;
preset{end}.hmax = 2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPM buttons';
preset{end}.pickup_comment = 'arc small, D = 49mm'; 
preset{end}.model_saved = 'mesh-lhc-bpm.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Concave';
preset{end}.electrode_amount = 4;
preset{end}.R = 24.5;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 24*[1 1 1 1]; 
preset{end}.ethick = 2.5*[1 1 1 1]; 
preset{end}.gapback = 3*[1 1 1 1]; 
preset{end}.gapside = 0.4*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.1;
preset{end}.hmax = 1.5; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMBH buttons'; 
preset{end}.pickup_comment = 'transfer line from SPS, D = 156mm'; 
preset{end}.model_saved = 'mesh-lhc-bpmbh.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 78;
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 78*[1 1 1 1]; 
preset{end}.gapback = 4*[1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMBV buttons)'; 
preset{end}.pickup_comment = 'transfer line from SPS, D = 83mm';
preset{end}.model_saved = 'mesh-lhc-bpmbv.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 41.5;
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 41.5*[1 1 1 1]; 
preset{end}.gapback = 4*[1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMIA buttons'; 
preset{end}.pickup_comment = 'transfer line from SPS, D = 80mm';
preset{end}.model_saved = 'mesh-lhc-bpmia.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 40;
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 40*[1 1 1 1]; 
preset{end}.gapback = 4*[1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'BPMI buttons'; 
preset{end}.pickup_comment = 'transfer line from SPS, D = 60mm';
preset{end}.model_saved = 'mesh-lhc-bpmi.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Rectangle';
preset{end}.electrode_amount = 4;
preset{end}.R = 30;
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.ewidth = 34*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 30*[1 1 1 1]; 
preset{end}.gapback = 4*[1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.25;
preset{end}.hmax = 2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 2; 
preset{end}.step_poly_xy = 2; 


preset{end+1}.machine_name = 'LHC';
preset{end}.pickup_name = 'TCSM collimator'; 
preset{end}.pickup_comment = 'fully closed jaws'; 
preset{end}.model_saved = 'mesh-lhc-tcsm.mat';
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 2;
preset{end}.body = [0 35.5; 8 23.3; 8 8.5; 8.5 8.5; 8.5 7.6; 16.5 7.6; 16.5 -7.6; 8.5 -7.6; 8.5 -8.5; 8 -8.5; 8 -23.3; 0 -35.5; -8 -23.3; -8 -8.5;  -8.5 -8.5; -8.5 -7.6; -16.5 -7.6; -16.5 7.6; -8.5 7.6; -8.5 8.5; -8 8.5; -8 23.3; 0 35.5];
preset{end}.elec(:,:,1) = [8.5 7.1; 12.5 7.1; 12.5 3.5; 13.5 3.5; 13.5 -3.5; 12.5 -3.5; 12.5 -7.1; 8.5 -7.1; 8.5 7.1]; 
preset{end}.elec(:,:,2) = [-8.5 7.1; -12.5 7.1; -12.5 3.5; -13.5 3.5; -13.5 -3.5;  -12.5 -3.5; -12.5 -7.1; -8.5 -7.1; -8.5 7.1]; 
preset{end}.symmetry = '2-fold (V axis)'; 
preset{end}.refinement = [false false false true]; 
preset{end}.hmin = 0.25; 
preset{end}.hmax = 3; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.electrode_pair = 'hor';


preset{end+1}.machine_name = 'SPS';
preset{end}.pickup_name = 'Collimator BPM Prototype'; 
preset{end}.pickup_comment = 'fully closed jaws'; 
preset{end}.model_saved = 'mesh-sps-coll.mat';
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 2;
preset{end}.body = [0 20; 10 20; 10 6.2; 10.6 6.2; 10.6 5.65; 17.1 5.65; 17.1 -5.65; 10.6 -5.65; 10.6 -6.2; 10 -6.2; 10 -20; 0 -20; 0 -20; -10 -20; -10 -6.2; -10.6 -6.2; -10.6 -6.2; -10.6 -5.65; -17.1 -5.65; -17.1 5.65; -10.6 5.65; -10.6 6.2; -10 6.2; -10 20; 0 20];
preset{end}.elec(:,:,1) = [10.6 5.15; 13.1 5.15; 13.1 2.45; 14.1 2.45; 14.1 -2.45; 13.1 -2.45; 13.1 -5.15; 10.6 -5.15; 10.6 5.15]; 
preset{end}.elec(:,:,2) = [-10.6 5.15; -13.1 5.15; -13.1 2.45; -14.1 2.45; -14.1 -2.45; -13.1 -2.45; -13.1 -5.15; -10.6 -5.15; -10.6 5.15]; 
preset{end}.symmetry = '2-fold (V axis)'; 
preset{end}.refinement = [false false false true]; 
preset{end}.hmin = 0.15; 
preset{end}.hmax = 2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.electrode_pair = 'hor';


preset{end+1}.machine_name = 'SPS';
preset{end}.pickup_name = 'BPCE stripline';
preset{end}.pickup_comment = 'D = 221mm'; 
preset{end}.model_saved = 'mesh-sps-bpce.mat';
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 110.5;
preset{end}.input_by = 'electrode width';  
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 19.64*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 105*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 200; 
preset{end}.hmin = 0.35;
preset{end}.hmax = 2.5; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'}; 
preset{end}.step_dos_xy = 4; 


preset{end+1}.machine_name = 'SPS';
preset{end}.pickup_name = 'BPCN stripline';
preset{end}.pickup_comment = 'D = 93mm'; 
preset{end}.model_saved = 'mesh-sps-bpcn.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Arc';
preset{end}.electrode_amount = 4;
preset{end}.R = 46.5;
preset{end}.input_by = 'electrode width';  
preset{end}.aorie_deg = [0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 19.64*[1 1 1 1]; 
preset{end}.ethick = [1 1 1 1]; 
preset{end}.edist  = 41*[1 1 1 1]; 
preset{end}.gapback = [1 1 1 1]; 
preset{end}.gapside = [1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 200; 
preset{end}.hmin = 0.27;
preset{end}.hmax = 1.2; 
preset{end}.abcd_treatments = {'delta/sum (2 electrodes)', '20log10 (2 electrodes)', 'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)'};  
preset{end}.step_dos_xy = 2; 


preset{end+1}.machine_name = 'Sirius';
preset{end}.pickup_name = 'Sirius BPM'; 
preset{end}.pickup_comment = 'test'; 
preset{end}.model_saved = 'mesh-sirius.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [5.82467241 10.49157716; 6.39955022 11.06645498; 6.65940348 10.80660172; 8.09436254 10.80660172; 8.2357839 10.94802307; 10.94802307 8.2357839; 10.80660172 8.09436254; 10.80660172 6.65940348; 11.06645498 6.39955022; 10.49157716 5.82467241; 10.5567 5.7058; 10.6201 5.5869; 10.6818 5.4681; 10.7418 5.3492; 10.8002 5.2303; 10.8569 5.1114; 10.9121 4.9926; 10.9657 4.8737; 11.0178 4.7548; 11.0683 4.6360; 11.1174 4.5171; 11.1649 4.3982; 11.2110 4.2794; 11.2557 4.1605; 11.2989 4.0416; 11.3407 3.9227; 11.3812 3.8039; 11.4202 3.6850; 11.4579 3.5661; 11.4942 3.4473; 11.5292 3.3284; 11.5628 3.2095; 11.5952 3.0906; 11.6262 2.9718; 11.6559 2.8529; 11.6844 2.7340; 11.7116 2.6152; 11.7375 2.4963; 11.7621 2.3774; 11.7855 2.2585; 11.8077 2.1397; 11.8286 2.0208; 11.8483 1.9019; 11.8668 1.7831; 11.8840 1.6642; 11.9001 1.5453; 11.9149 1.4265; 11.9285 1.3076; 11.9410 1.1887; 11.9522 1.0698; 11.9623 0.9510; 11.9711 0.8321; 11.9788 0.7132; 11.9853 0.5944; 11.9906 0.4755; 11.9947 0.3566; 11.9976 0.2377; 11.9994 0.1189; 12 0; 11.9994 -0.1189; 11.9976 -0.2377; 11.9947 -0.3566; 11.9906 -0.4755; 11.9853 -0.5944; 11.9788 -0.7132; 11.9711 -0.8321; 11.9623 -0.9510; 11.9522 -1.0698; 11.9410 -1.1887; 11.9285 -1.3076; 11.9149 -1.4265; 11.9001 -1.5453; 11.8840 -1.6642; 11.8668 -1.7831; 11.8483 -1.9019; 11.8286 -2.0208; 11.8077 -2.1397; 11.7855 -2.2585; 11.7621 -2.3774; 11.7375 -2.4963; 11.7116 -2.6152; 11.6844 -2.7340; 11.6559 -2.8529; 11.6262 -2.9718; 11.5952 -3.0906; 11.5628 -3.2095; 11.5292 -3.3284; 11.4942 -3.4473; 11.4579 -3.5661; 11.4202 -3.6850; 11.3812 -3.8039; 11.3407 -3.9227; 11.2989 -4.0416; 11.2557 -4.1605; 11.2110 -4.2794; 11.1649 -4.3982; 11.1174 -4.5171; 11.0683 -4.6360; 11.0178 -4.7548; 10.9657 -4.8737; 10.9121 -4.9926; 10.8569 -5.1114; 10.8002 -5.2303; 10.7418 -5.3492; 10.6818 -5.4681; 10.6201 -5.5869; 10.5567 -5.7058; 10.49157716 -5.82467241; 11.06645498 -6.39955022; 10.80660172 -6.65940348; 10.80660172 -8.09436254; 10.94802307 -8.2357839; 8.2357839 -10.94802307; 8.09436254 -10.80660172; 6.65940348 -10.80660172; 6.39955022 -11.06645498; 5.82467241 -10.49157716; 5.7058 -10.5567; 5.5869 -10.6201; 5.4681 -10.6818; 5.3492 -10.7418; 5.2303 -10.8002; 5.1114 -10.8569; 4.9926 -10.9121; 4.8737 -10.9657; 4.7548 -11.0178; 4.6360 -11.0683; 4.5171 -11.1174; 4.3982 -11.1649; 4.2794 -11.2110; 4.1605 -11.2557; 4.0416 -11.2989; 3.9227 -11.3407; 3.8039 -11.3812; 3.6850 -11.4202; 3.5661 -11.4579; 3.4473 -11.4942; 3.3284 -11.5292; 3.2095 -11.5628; 3.0906 -11.5952; 2.9718 -11.6262; 2.8529 -11.6559; 2.7340 -11.6844; 2.6152 -11.7116; 2.4963 -11.7375; 2.3774 -11.7621; 2.2585 -11.7855; 2.1397 -11.8077; 2.0208 -11.8286; 1.9019 -11.8483; 1.7831 -11.8668; 1.6642 -11.8840; 1.5453 -11.9001; 1.4265 -11.9149; 1.3076 -11.9285; 1.1887 -11.9410; 1.0698 -11.9522; 0.9510 -11.9623; 0.8321 -11.9711; 0.7132 -11.9788; 0.5944 -11.9853; 0.4755 -11.9906; 0.3566 -11.9947; 0.2377 -11.9976; 0.1189 -11.9994; 0 -12; -0.1189 -11.9994; -0.2377 -11.9976; -0.3566 -11.9947; -0.4755 -11.9906; -0.5944 -11.9853; -0.7132 -11.9788; -0.8321 -11.9711; -0.9510 -11.9623; -1.0698 -11.9522; -1.1887 -11.9410; -1.3076 -11.9285; -1.4265 -11.9149; -1.5453 -11.9001; -1.6642 -11.8840; -1.7831 -11.8668; -1.9019 -11.8483; -2.0208 -11.8286; -2.1397 -11.8077; -2.2585 -11.7855; -2.3774 -11.7621; -2.4963 -11.7375; -2.6152 -11.7116; -2.7340 -11.6844; -2.8529 -11.6559; -2.9718 -11.6262; -3.0906 -11.5952; -3.2095 -11.5628; -3.3284 -11.5292; -3.4473 -11.4942; -3.5661 -11.4579; -3.6850 -11.4202; -3.8039 -11.3812; -3.9227 -11.3407; -4.0416 -11.2989; -4.1605 -11.2557; -4.2794 -11.2110; -4.3982 -11.1649; -4.5171 -11.1174; -4.6360 -11.0683; -4.7548 -11.0178; -4.8737 -10.9657; -4.9926 -10.9121; -5.1114 -10.8569; -5.2303 -10.8002; -5.3492 -10.7418; -5.4681 -10.6818; -5.5869 -10.6201; -5.7058 -10.5567; -5.82467241 -10.49157716; -6.39955022 -11.06645498; -6.65940348 -10.80660172; -8.09436254 -10.80660172; -8.2357839 -10.94802307; -10.94802307 -8.2357839; -10.80660172 -8.09436254; -10.80660172 -6.65940348; -11.06645498 -6.39955022; -10.49157716 -5.82467241; -10.5567 -5.7058; -10.6201 -5.5869; -10.6818 -5.4681; -10.7418 -5.3492; -10.8002 -5.2303; -10.8569 -5.1114; -10.9121 -4.9926; -10.9657 -4.8737; -11.0178 -4.7548; -11.0683 -4.6360; -11.1174 -4.5171; -11.1649 -4.3982; -11.2110 -4.2794; -11.2557 -4.1605; -11.2989 -4.0416; -11.3407 -3.9227; -11.3812 -3.8039; -11.4202 -3.6850; -11.4579 -3.5661; -11.4942 -3.4473; -11.5292 -3.3284; -11.5628 -3.2095; -11.5952 -3.0906; -11.6262 -2.9718; -11.6559 -2.8529; -11.6844 -2.7340; -11.7116 -2.6152; -11.7375 -2.4963; -11.7621 -2.3774; -11.7855 -2.2585; -11.8077 -2.1397; -11.8286 -2.0208; -11.8483 -1.9019; -11.8668 -1.7831; -11.8840 -1.6642; -11.9001 -1.5453; -11.9149 -1.4265; -11.9285 -1.3076; -11.9410 -1.1887; -11.9522 -1.0698; -11.9623 -0.9510; -11.9711 -0.8321; -11.9788 -0.7132; -11.9853 -0.5944; -11.9906 -0.4755; -11.9947 -0.3566; -11.9976 -0.2377; -11.9994 -0.1189; -12 0; -11.9994 0.1189; -11.9976 0.2377; -11.9947 0.3566; -11.9906 0.4755; -11.9853 0.5944; -11.9788 0.7132; -11.9711 0.8321; -11.9623 0.9510; -11.9522 1.0698; -11.9410 1.1887; -11.9285 1.3076; -11.9149 1.4265; -11.9001 1.5453; -11.8840 1.6642; -11.8668 1.7831; -11.8483 1.9019; -11.8286 2.0208; -11.8077 2.1397; -11.7855 2.2585; -11.7621 2.3774; -11.7375 2.4963; -11.7116 2.6152; -11.6844 2.7340; -11.6559 2.8529; -11.6262 2.9718; -11.5952 3.0906; -11.5628 3.2095; -11.5292 3.3284; -11.4942 3.4473; -11.4579 3.5661; -11.4202 3.6850; -11.3812 3.8039; -11.3407 3.9227; -11.2989 4.0416; -11.2557 4.1605; -11.2110 4.2794; -11.1649 4.3982; -11.1174 4.5171; -11.0683 4.6360; -11.0178 4.7548; -10.9657 4.8737; -10.9121 4.9926; -10.8569 5.1114; -10.8002 5.2303; -10.7418 5.3492; -10.6818 5.4681; -10.6201 5.5869; -10.5567 5.7058; -10.49157716 5.82467241; -11.06645498 6.39955022; -10.80660172 6.65940348; -10.80660172 8.09436254; -10.94802307 8.2357839; -8.2357839 10.94802307; -8.09436254 10.80660172; -6.65940348 10.80660172; -6.39955022 11.06645498; -5.82467241 10.49157716; -5.7058 10.5567; -5.5869 10.6201; -5.4681 10.6818; -5.3492 10.7418; -5.2303 10.8002; -5.1114 10.8569; -4.9926 10.9121; -4.8737 10.9657; -4.7548 11.0178; -4.6360 11.0683; -4.5171 11.1174; -4.3982 11.1649; -4.2794 11.2110; -4.1605 11.2557; -4.0416 11.2989; -3.9227 11.3407; -3.8039 11.3812; -3.6850 11.4202; -3.5661 11.4579; -3.4473 11.4942; -3.3284 11.5292; -3.2095 11.5628; -3.0906 11.5952; -2.9718 11.6262; -2.8529 11.6559; -2.7340 11.6844; -2.6152 11.7116; -2.4963 11.7375; -2.3774 11.7621; -2.2585 11.7855; -2.1397 11.8077; -2.0208 11.8286; -1.9019 11.8483; -1.7831 11.8668; -1.6642 11.8840; -1.5453 11.9001; -1.4265 11.9149; -1.3076 11.9285; -1.1887 11.9410; -1.0698 11.9522; -0.9510 11.9623; -0.8321 11.9711; -0.7132 11.9788; -0.5944 11.9853; -0.4755 11.9906; -0.3566 11.9947; -0.2377 11.9976; -0.1189 11.9994; 0 12; 0.11887087 11.99941122;0.23774173 11.99764472;0.3566126 11.99469997;0.47548346 11.99057611;0.59435433 11.98527192;0.71322519 11.97878582;0.83209606 11.97111591;0.95096692 11.9622599;1.06983779 11.95221515;1.18870865 11.94097868;1.30757952 11.9285471;1.42645039 11.91491667;1.54532125 11.90008329;1.66419212 11.88404244;1.78306298 11.86678922;1.90193385 11.84831835;2.02080471 11.82862411;2.13967558 11.80770039;2.25854644 11.78554063;2.37741731 11.76213786;2.49628817 11.73748463;2.61515904 11.71157305;2.73402991 11.68439474;2.85290077 11.65594085;2.97177164 11.62620202;3.0906425 11.59516834;3.20951337 11.56282941;3.32838423 11.52917423;3.4472551 11.49419124;3.56612596 11.45786828;3.68499683 11.42019257;3.80386769 11.38115067;3.92273856 11.34072847;4.04160943 11.29891115;4.16048029 11.25568318;4.27935116 11.21102822;4.39822202 11.16492916;4.51709289 11.11736803;4.63596375 11.06832598;4.75483462 11.01778325;4.87370548 10.96571908;4.99257635 10.91211168;5.11144721 10.85693821;5.23031808 10.80017466;5.34918894 10.74179583;5.46805981 10.68177522;5.58693068 10.62008501;5.70580154 10.55669592]; 
preset{end}.elec(:,:,1) = [6.36396103 10.60660172; 8.29436254 10.60660172; 10.60660172 8.29436254; 10.60660172 6.36396103; 6.36396103 10.60660172];
preset{end}.elec(:,:,4) = [10.60660172 -6.36396103; 10.60660172 -8.29436254; 8.29436254 -10.60660172; 6.36396103 -10.60660172; 10.60660172 -6.36396103];
preset{end}.elec(:,:,3) = [-6.36396103 -10.60660172; -8.29436254 -10.60660172; -10.60660172 -8.29436254; -10.60660172 -6.36396103; -6.36396103 -10.60660172];
preset{end}.elec(:,:,2) = [-10.60660172 6.36396103; -10.60660172 8.29436254; -8.29436254 10.60660172; -6.36396103 10.60660172; -10.60660172 6.36396103];
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 600; 
preset{end}.refinement = [true true false true]; 
preset{end}.hmin = 0.05; 
preset{end}.hmax = 0.4; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [5 5];
preset{end}.roi_poly_sum_xy = [5 5];
preset{end}.roi_poly_Q_xy = [5 5];
preset{end}.step_dos_xy = 0.5; 
preset{end}.step_poly_xy = 0.5; 
preset{end}.poly_powers = [5 3 7];


preset{end+1}.machine_name = 'Sirius';
preset{end}.pickup_name = 'ILF-3'; 
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = '';%'mesh-sirius.mat'; 
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [0 13; 0.13383338 12.99931108; 0.26766675 12.99724411; 0.40150013 12.99379843; 0.53533351 12.98897294; 0.66916689 12.9827661; 0.80300026 12.97517594; 0.93683364 12.96620001; 1.07066702 12.95583545; 1.2045004 12.94407891; 1.33833377 12.9309266; 1.47216715 12.91637425; 1.60600053 12.90041714; 1.73983391 12.88305003; 1.87366728 12.86426721; 2.00750066 12.84406248; 2.14133404 12.82242912; 2.27516742 12.79935988; 2.40900079 12.77484697; 2.54283417 12.74888208; 2.67666755 12.72145632; 2.81050093 12.6925602; 2.9443343 12.66218368; 3.07816768 12.63031606; 3.21200106 12.59694603; 3.34583444 12.56206161; 3.47966781 12.52565016; 3.61350119 12.48769831; 3.74733457 12.44819198; 3.88116794 12.40711632; 4.01500132 12.36445568; 4.1488347 12.32019361; 4.28266808 12.27431278; 4.41650145 12.22679496; 4.55033483 12.17762099; 4.68416821 12.12677072; 4.81800159 12.07422299; 4.95183496 12.01995551; 5.08566834 11.9639449; 5.21950172 11.90616655; 5.3533351 11.84659459; 5.48716847 11.78520183; 5.62100185 11.72195966; 5.75483523 11.65683797; 5.88866861 11.58980509; 6.02250198 11.52082766; 6.15633536 11.44987052; 6.29016874 11.37689664; 6.42400212 11.30186696; 6.55783549 11.22474025; 7.13271331 11.79961806; 7.40862287 11.5237085; 8.79146932 11.5237085; 9.07431204 11.80655121; 11.80655121 9.07431204; 11.5237085 8.79146932; 11.5237085 7.40862287; 11.79961806 7.13271331; 11.22474025 6.55783549; 11.3019 6.4240; 11.3769 6.2902; 11.4499 6.1563; 11.5208 6.0225; 11.5898 5.8887; 11.6568 5.7548; 11.7220 5.6210; 11.7852 5.4872; 11.8466 5.3533; 11.9062 5.2195; 11.9639 5.0857; 12.0200 4.9518; 12.0742 4.8180; 12.1268 4.6842; 12.1776 4.5503; 12.2268 4.4165; 12.2743 4.2827; 12.3202 4.1488; 12.3645 4.0150; 12.4071 3.8812; 12.4482 3.7473; 12.4877 3.6135; 12.5257 3.4797; 12.5621 3.3458; 12.5969 3.2120; 12.6303 3.0782; 12.6622 2.9443; 12.6926 2.8105; 12.7215 2.6767; 12.7489 2.5428; 12.7748 2.4090; 12.7994 2.2752; 12.8224 2.1413; 12.8441 2.0075; 12.8643 1.8737; 12.8831 1.7398; 12.9004 1.6060; 12.9164 1.4722; 12.9309 1.3383; 12.9441 1.2045; 12.9558 1.0707; 12.9662 0.9368; 12.9752 0.8030; 12.9828 0.6692; 12.9890 0.5353; 12.9938 0.4015; 12.9972 0.2677; 12.9993 0.1338; 13 0; 12.9993 -0.1338; 12.9972 -0.2677; 12.9938 -0.4015; 12.9890 -0.5353; 12.9828 -0.6692; 12.9752 -0.8030; 12.9662 -0.9368; 12.9558 -1.0707; 12.9441 -1.2045; 12.9309 -1.3383; 12.9164 -1.4722; 12.9004 -1.6060; 12.8831 -1.7398; 12.8643 -1.8737; 12.8441 -2.0075; 12.8224 -2.1413; 12.7994 -2.2752; 12.7748 -2.4090; 12.7489 -2.5428; 12.7215 -2.6767; 12.6926 -2.8105; 12.6622 -2.9443; 12.6303 -3.0782; 12.5969 -3.2120; 12.5621 -3.3458; 12.5257 -3.4797; 12.4877 -3.6135; 12.4482 -3.7473; 12.4071 -3.8812; 12.3645 -4.0150; 12.3202 -4.1488; 12.2743 -4.2827; 12.2268 -4.4165; 12.1776 -4.5503; 12.1268 -4.6842; 12.0742 -4.8180; 12.0200 -4.9518; 11.9639 -5.0857; 11.9062 -5.2195; 11.8466 -5.3533; 11.7852 -5.4872; 11.7220 -5.6210; 11.6568 -5.7548; 11.5898 -5.8887; 11.5208 -6.0225; 11.4499 -6.1563; 11.3769 -6.2902; 11.3019 -6.4240; 11.22474025 -6.55783549; 11.79961806 -7.13271331; 11.5237085 -7.40862287; 11.5237085 -8.79146932; 11.80655121 -9.07431204; 9.07431204 -11.80655121; 8.79146932 -11.5237085; 7.40862287 -11.5237085; 7.13271331 -11.79961806; 6.55783549 -11.22474025; 6.4240 -11.3019; 6.2902 -11.3769; 6.1563 -11.4499; 6.0225 -11.5208; 5.8887 -11.5898; 5.7548 -11.6568; 5.6210 -11.7220; 5.4872 -11.7852; 5.3533 -11.8466; 5.2195 -11.9062; 5.0857 -11.9639; 4.9518 -12.0200; 4.8180 -12.0742; 4.6842 -12.1268; 4.5503 -12.1776; 4.4165 -12.2268; 4.2827 -12.2743; 4.1488 -12.3202; 4.0150 -12.3645; 3.8812 -12.4071; 3.7473 -12.4482; 3.6135 -12.4877; 3.4797 -12.5257; 3.3458 -12.5621; 3.2120 -12.5969; 3.0782 -12.6303; 2.9443 -12.6622; 2.8105 -12.6926; 2.6767 -12.7215; 2.5428 -12.7489; 2.4090 -12.7748; 2.2752 -12.7994; 2.1413 -12.8224; 2.0075 -12.8441; 1.8737 -12.8643; 1.7398 -12.8831; 1.6060 -12.9004; 1.4722 -12.9164; 1.3383 -12.9309; 1.2045 -12.9441; 1.0707 -12.9558; 0.9368 -12.9662; 0.8030 -12.9752; 0.6692 -12.9828; 0.5353 -12.9890; 0.4015 -12.9938; 0.2677 -12.9972; 0.1338 -12.9993; 0 -13; -0.1338 -12.9993; -0.2677 -12.9972; -0.4015 -12.9938; -0.5353 -12.9890; -0.6692 -12.9828; -0.8030 -12.9752; -0.9368 -12.9662; -1.0707 -12.9558; -1.2045 -12.9441; -1.3383 -12.9309; -1.4722 -12.9164; -1.6060 -12.9004; -1.7398 -12.8831; -1.8737 -12.8643; -2.0075 -12.8441; -2.1413 -12.8224; -2.2752 -12.7994; -2.4090 -12.7748; -2.5428 -12.7489; -2.6767 -12.7215; -2.8105 -12.6926; -2.9443 -12.6622; -3.0782 -12.6303; -3.2120 -12.5969; -3.3458 -12.5621; -3.4797 -12.5257; -3.6135 -12.4877; -3.7473 -12.4482; -3.8812 -12.4071; -4.0150 -12.3645; -4.1488 -12.3202; -4.2827 -12.2743; -4.4165 -12.2268; -4.5503 -12.1776; -4.6842 -12.1268; -4.8180 -12.0742; -4.9518 -12.0200; -5.0857 -11.9639; -5.2195 -11.9062; -5.3533 -11.8466; -5.4872 -11.7852; -5.6210 -11.7220; -5.7548 -11.6568; -5.8887 -11.5898; -6.0225 -11.5208; -6.1563 -11.4499; -6.2902 -11.3769; -6.4240 -11.3019; -6.55783549 -11.22474025; -7.13271331 -11.79961806; -7.40862287 -11.5237085; -8.79146932 -11.5237085; -9.07431204 -11.80655121; -11.80655121 -9.07431204; -11.5237085 -8.79146932; -11.5237085 -7.40862287; -11.79961806 -7.13271331; -11.22474025 -6.55783549; -11.3019 -6.4240; -11.3769 -6.2902; -11.4499 -6.1563; -11.5208 -6.0225; -11.5898 -5.8887; -11.6568 -5.7548; -11.7220 -5.6210; -11.7852 -5.4872; -11.8466 -5.3533; -11.9062 -5.2195; -11.9639 -5.0857; -12.0200 -4.9518; -12.0742 -4.8180; -12.1268 -4.6842; -12.1776 -4.5503; -12.2268 -4.4165; -12.2743 -4.2827; -12.3202 -4.1488; -12.3645 -4.0150; -12.4071 -3.8812; -12.4482 -3.7473; -12.4877 -3.6135; -12.5257 -3.4797; -12.5621 -3.3458; -12.5969 -3.2120; -12.6303 -3.0782; -12.6622 -2.9443; -12.6926 -2.8105; -12.7215 -2.6767; -12.7489 -2.5428; -12.7748 -2.4090; -12.7994 -2.2752; -12.8224 -2.1413; -12.8441 -2.0075; -12.8643 -1.8737; -12.8831 -1.7398; -12.9004 -1.6060; -12.9164 -1.4722; -12.9309 -1.3383; -12.9441 -1.2045; -12.9558 -1.0707; -12.9662 -0.9368; -12.9752 -0.8030; -12.9828 -0.6692; -12.9890 -0.5353; -12.9938 -0.4015; -12.9972 -0.2677; -12.9993 -0.1338; -13 0; -12.9993 0.1338; -12.9972 0.2677; -12.9938 0.4015; -12.9890 0.5353; -12.9828 0.6692; -12.9752 0.8030; -12.9662 0.9368; -12.9558 1.0707; -12.9441 1.2045; -12.9309 1.3383; -12.9164 1.4722; -12.9004 1.6060; -12.8831 1.7398; -12.8643 1.8737; -12.8441 2.0075; -12.8224 2.1413; -12.7994 2.2752; -12.7748 2.4090; -12.7489 2.5428; -12.7215 2.6767; -12.6926 2.8105; -12.6622 2.9443; -12.6303 3.0782; -12.5969 3.2120; -12.5621 3.3458; -12.5257 3.4797; -12.4877 3.6135; -12.4482 3.7473; -12.4071 3.8812; -12.3645 4.0150; -12.3202 4.1488; -12.2743 4.2827; -12.2268 4.4165; -12.1776 4.5503; -12.1268 4.6842; -12.0742 4.8180; -12.0200 4.9518; -11.9639 5.0857; -11.9062 5.2195; -11.8466 5.3533; -11.7852 5.4872; -11.7220 5.6210; -11.6568 5.7548; -11.5898 5.8887; -11.5208 6.0225; -11.4499 6.1563; -11.3769 6.2902; -11.3019 6.4240; -11.22474025 6.55783549; -11.79961806 7.13271331; -11.5237085 7.40862287; -11.5237085 8.79146932; -11.80655121 9.07431204; -9.07431204 11.80655121; -8.79146932 11.5237085; -7.40862287 11.5237085; -7.13271331 11.79961806; -6.55783549 11.22474025; -6.4240 11.3019; -6.2902 11.3769; -6.1563 11.4499; -6.0225 11.5208; -5.8887 11.5898; -5.7548 11.6568; -5.6210 11.7220; -5.4872 11.7852; -5.3533 11.8466; -5.2195 11.9062; -5.0857 11.9639; -4.9518 12.0200; -4.8180 12.0742; -4.6842 12.1268; -4.5503 12.1776; -4.4165 12.2268; -4.2827 12.2743; -4.1488 12.3202; -4.0150 12.3645; -3.8812 12.4071; -3.7473 12.4482; -3.6135 12.4877; -3.4797 12.5257; -3.3458 12.5621; -3.2120 12.5969; -3.0782 12.6303; -2.9443 12.6622; -2.8105 12.6926; -2.6767 12.7215; -2.5428 12.7489; -2.4090 12.7748; -2.2752 12.7994; -2.1413 12.8224; -2.0075 12.8441; -1.8737 12.8643; -1.7398 12.8831; -1.6060 12.9004; -1.4722 12.9164; -1.3383 12.9309; -1.2045 12.9441; -1.0707 12.9558; -0.9368 12.9662; -0.8030 12.9752; -0.6692 12.9828; -0.5353 12.9890; -0.4015 12.9938; -0.2677 12.9972; -0.1338 12.9993; 0 13]; 
preset{end}.elec(:,:,1) = [ 7.07106781 11.3137085; 9.28431204 11.3137085; 11.3137085 9.28431204; 11.3137085 7.07106781; 7.07106781 11.3137085];
preset{end}.elec(:,:,2) = [ -11.3137085 7.07106781; -11.3137085 9.28431204; -9.28431204 11.3137085; -7.07106781 11.3137085; -11.3137085 7.07106781];
preset{end}.elec(:,:,3) = [ -7.07106781 -11.3137085; -9.28431204 -11.3137085; -11.3137085 -9.28431204; -11.3137085 -7.07106781; -7.07106781 -11.3137085];
preset{end}.elec(:,:,4) = [ 11.3137085 -7.07106781; 11.3137085 -9.28431204; 9.28431204 -11.3137085; 7.07106781 -11.3137085; 11.3137085 -7.07106781];
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 600; 
preset{end}.refinement = [true true false true]; 
preset{end}.hmin = 0.05; 
preset{end}.hmax = 0.4; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [5 5];
preset{end}.roi_poly_sum_xy = [5 5];
preset{end}.roi_poly_Q_xy = [5 5];
preset{end}.step_dos_xy = 0.5; 
preset{end}.step_poly_xy = 0.5; 
preset{end}.poly_powers = [5 3 7];

preset{end+1}.machine_name = 'Sirius';
preset{end}.pickup_name = '1 ILSF'; 
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = '';
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [6.3146078 11.36335022;6.91564857 11.96439099;7.36633106 11.5137085;8.79633106 11.5137085;9.08431204 11.80168948;11.80168948 9.08431204;11.5137085 8.79633106;11.5137085 7.36633106;11.96439099 6.91564857;11.36335022 6.3146078;11.4340 6.1857;11.5028 6.0569;11.5697 5.9280;11.6349 5.7991;11.6982 5.6703;11.7598 5.5414;11.8197 5.4125;11.8778 5.2837;11.9343 5.1548;11.9892 5.0259;12.0424 4.8970;12.0940 4.7682;12.1440 4.6393;12.1925 4.5104;12.2394 4.3816;12.2847 4.2527;12.3286 4.1238;12.3709 3.9950;12.4118 3.8661;12.4512 3.7372;12.4892 3.6083;12.5257 3.4795;12.5608 3.3506;12.5945 3.2217;12.6267 3.0929;12.6576 2.9640;12.6871 2.8351;12.7152 2.7063;12.7419 2.5774;12.7673 2.4485;12.7914 2.3197;12.8141 2.1908;12.8354 2.0619;12.8555 1.9330;12.8742 1.8042;12.8916 1.6753;12.9077 1.5464;12.9225 1.4176;12.9360 1.2887;12.9482 1.1598;12.9591 1.0310;12.9687 0.9021;12.9770 0.7732;12.9840 0.6443;12.9898 0.5155;12.9943 0.3866;12.9974 0.2577;12.9994 0.1289;13 0;12.9994 -0.1289;12.9974 -0.2577;12.9943 -0.3866;12.9898 -0.5155;12.9840 -0.6443;12.9770 -0.7732;12.9687 -0.9021;12.9591 -1.0310;12.9482 -1.1598;12.9360 -1.2887;12.9225 -1.4176;12.9077 -1.5464;12.8916 -1.6753;12.8742 -1.8042;12.8555 -1.9330;12.8354 -2.0619;12.8141 -2.1908;12.7914 -2.3197;12.7673 -2.4485;12.7419 -2.5774;12.7152 -2.7063;12.6871 -2.8351;12.6576 -2.9640;12.6267 -3.0929;12.5945 -3.2217;12.5608 -3.3506;12.5257 -3.4795;12.4892 -3.6083;12.4512 -3.7372;12.4118 -3.8661;12.3709 -3.9950;12.3286 -4.1238;12.2847 -4.2527;12.2394 -4.3816;12.1925 -4.5104;12.1440 -4.6393;12.0940 -4.7682;12.0424 -4.8970;11.9892 -5.0259;11.9343 -5.1548;11.8778 -5.2837;11.8197 -5.4125;11.7598 -5.5414;11.6982 -5.6703;11.6349 -5.7991;11.5697 -5.9280;11.5028 -6.0569;11.4340 -6.1857;11.36335022 -6.3146078;11.96439099 -6.91564857;11.5137085 -7.36633106;11.5137085 -8.79633106;11.80168948 -9.08431204;9.08431204 -11.80168948;8.79633106 -11.5137085;7.36633106 -11.5137085;6.91564857 -11.96439099;6.3146078 -11.36335022;6.1857 -11.4340;6.0569 -11.5028;5.9280 -11.5697;5.7991 -11.6349;5.6703 -11.6982;5.5414 -11.7598;5.4125 -11.8197;5.2837 -11.8778;5.1548 -11.9343;5.0259 -11.9892;4.8970 -12.0424;4.7682 -12.0940;4.6393 -12.1440;4.5104 -12.1925;4.3816 -12.2394;4.2527 -12.2847;4.1238 -12.3286;3.9950 -12.3709;3.8661 -12.4118;3.7372 -12.4512;3.6083 -12.4892;3.4795 -12.5257;3.3506 -12.5608;3.2217 -12.5945;3.0929 -12.6267;2.9640 -12.6576;2.8351 -12.6871;2.7063 -12.7152;2.5774 -12.7419;2.4485 -12.7673;2.3197 -12.7914;2.1908 -12.8141;2.0619 -12.8354;1.9330 -12.8555;1.8042 -12.8742;1.6753 -12.8916;1.5464 -12.9077;1.4176 -12.9225;1.2887 -12.9360;1.1598 -12.9482;1.0310 -12.9591;0.9021 -12.9687;0.7732 -12.9770;0.6443 -12.9840;0.5155 -12.9898;0.3866 -12.9943;0.2577 -12.9974;0.1289 -12.9994;0 -13;-0.1289 -12.9994;-0.2577 -12.9974;-0.3866 -12.9943;-0.5155 -12.9898;-0.6443 -12.9840;-0.7732 -12.9770;-0.9021 -12.9687;-1.0310 -12.9591;-1.1598 -12.9482;-1.2887 -12.9360;-1.4176 -12.9225;-1.5464 -12.9077;-1.6753 -12.8916;-1.8042 -12.8742;-1.9330 -12.8555;-2.0619 -12.8354;-2.1908 -12.8141;-2.3197 -12.7914;-2.4485 -12.7673;-2.5774 -12.7419;-2.7063 -12.7152;-2.8351 -12.6871;-2.9640 -12.6576;-3.0929 -12.6267;-3.2217 -12.5945;-3.3506 -12.5608;-3.4795 -12.5257;-3.6083 -12.4892;-3.7372 -12.4512;-3.8661 -12.4118;-3.9950 -12.3709;-4.1238 -12.3286;-4.2527 -12.2847;-4.3816 -12.2394;-4.5104 -12.1925;-4.6393 -12.1440;-4.7682 -12.0940;-4.8970 -12.0424;-5.0259 -11.9892;-5.1548 -11.9343;-5.2837 -11.8778;-5.4125 -11.8197;-5.5414 -11.7598;-5.6703 -11.6982;-5.7991 -11.6349;-5.9280 -11.5697;-6.0569 -11.5028;-6.1857 -11.4340;-6.3146078 -11.36335022;-6.91564857 -11.96439099;-7.36633106 -11.5137085;-8.79633106 -11.5137085;-9.08431204 -11.80168948;-11.80168948 -9.08431204;-11.5137085 -8.79633106;-11.5137085 -7.36633106;-11.96439099 -6.91564857;-11.36335022 -6.3146078;-11.4340 -6.1857;-11.5028 -6.0569;-11.5697 -5.9280;-11.6349 -5.7991;-11.6982 -5.6703;-11.7598 -5.5414;-11.8197 -5.4125;-11.8778 -5.2837;-11.9343 -5.1548;-11.9892 -5.0259;-12.0424 -4.8970;-12.0940 -4.7682;-12.1440 -4.6393;-12.1925 -4.5104;-12.2394 -4.3816;-12.2847 -4.2527;-12.3286 -4.1238;-12.3709 -3.9950;-12.4118 -3.8661;-12.4512 -3.7372;-12.4892 -3.6083;-12.5257 -3.4795;-12.5608 -3.3506;-12.5945 -3.2217;-12.6267 -3.0929;-12.6576 -2.9640;-12.6871 -2.8351;-12.7152 -2.7063;-12.7419 -2.5774;-12.7673 -2.4485;-12.7914 -2.3197;-12.8141 -2.1908;-12.8354 -2.0619;-12.8555 -1.9330;-12.8742 -1.8042;-12.8916 -1.6753;-12.9077 -1.5464;-12.9225 -1.4176;-12.9360 -1.2887;-12.9482 -1.1598;-12.9591 -1.0310;-12.9687 -0.9021;-12.9770 -0.7732;-12.9840 -0.6443;-12.9898 -0.5155;-12.9943 -0.3866;-12.9974 -0.2577;-12.9994 -0.1289;-13 0;-12.9994 0.1289;-12.9974 0.2577;-12.9943 0.3866;-12.9898 0.5155;-12.9840 0.6443;-12.9770 0.7732;-12.9687 0.9021;-12.9591 1.0310;-12.9482 1.1598;-12.9360 1.2887;-12.9225 1.4176;-12.9077 1.5464;-12.8916 1.6753;-12.8742 1.8042;-12.8555 1.9330;-12.8354 2.0619;-12.8141 2.1908;-12.7914 2.3197;-12.7673 2.4485;-12.7419 2.5774;-12.7152 2.7063;-12.6871 2.8351;-12.6576 2.9640;-12.6267 3.0929;-12.5945 3.2217;-12.5608 3.3506;-12.5257 3.4795;-12.4892 3.6083;-12.4512 3.7372;-12.4118 3.8661;-12.3709 3.9950;-12.3286 4.1238;-12.2847 4.2527;-12.2394 4.3816;-12.1925 4.5104;-12.1440 4.6393;-12.0940 4.7682;-12.0424 4.8970;-11.9892 5.0259;-11.9343 5.1548;-11.8778 5.2837;-11.8197 5.4125;-11.7598 5.5414;-11.6982 5.6703;-11.6349 5.7991;-11.5697 5.9280;-11.5028 6.0569;-11.4340 6.1857;-11.36335022 6.3146078;-11.96439099 6.91564857;-11.5137085 7.36633106;-11.5137085 8.79633106;-11.80168948 9.08431204;-9.08431204 11.80168948;-8.79633106 11.5137085;-7.36633106 11.5137085;-6.91564857 11.96439099;-6.3146078 11.36335022;-6.1857 11.4340;-6.0569 11.5028;-5.9280 11.5697;-5.7991 11.6349;-5.6703 11.6982;-5.5414 11.7598;-5.4125 11.8197;-5.2837 11.8778;-5.1548 11.9343;-5.0259 11.9892;-4.8970 12.0424;-4.7682 12.0940;-4.6393 12.1440;-4.5104 12.1925;-4.3816 12.2394;-4.2527 12.2847;-4.1238 12.3286;-3.9950 12.3709;-3.8661 12.4118;-3.7372 12.4512;-3.6083 12.4892;-3.4795 12.5257;-3.3506 12.5608;-3.2217 12.5945;-3.0929 12.6267;-2.9640 12.6576;-2.8351 12.6871;-2.7063 12.7152;-2.5774 12.7419;-2.4485 12.7673;-2.3197 12.7914;-2.1908 12.8141;-2.0619 12.8354;-1.9330 12.8555;-1.8042 12.8742;-1.6753 12.8916;-1.5464 12.9077;-1.4176 12.9225;-1.2887 12.9360;-1.1598 12.9482;-1.0310 12.9591;-0.9021 12.9687;-0.7732 12.9770;-0.6443 12.9840;-0.5155 12.9898;-0.3866 12.9943;-0.2577 12.9974;-0.1289 12.9994;0 13;0.12886955 12.99936124;0.25773909 12.99744477;0.38660864 12.99425003;0.51547819 12.98977607;0.64434774 12.98402156;0.77321728 12.97698482;0.90208683 12.96866375;1.03095638 12.95905587;1.15982592 12.94815832;1.28869547 12.93596784;1.41756502 12.92248078;1.54643456 12.90769306;1.67530411 12.89160022;1.80417366 12.87419735;1.93304321 12.85547914;2.06191275 12.83543984;2.1907823 12.81407324;2.31965185 12.79137269;2.44852139 12.76733108;2.57739094 12.74194082;2.70626049 12.71519383;2.83513003 12.68708153;2.96399958 12.65759481;3.09286913 12.62672406;3.22173868 12.5944591;3.35060822 12.56078917;3.47947777 12.52570295;3.60834732 12.48918851;3.73721686 12.45123328;3.86608641 12.41182403;3.99495596 12.37094689;4.12382551 12.32858723;4.25269505 12.28472974;4.3815646 12.2393583;4.51043415 12.19245602;4.63930369 12.14400516;4.76817324 12.0939871;4.89704279 12.04238232;5.02591233 11.98917033;5.15478188 11.93432963;5.28365143 11.87783766;5.41252098 11.81967075;5.54139052 11.75980404;5.67026007 11.69821143;5.79912962 11.63486552;5.92799916 11.5697375;6.05686871 11.50279711;6.18573826 11.43401252;6.3146078 11.36335022]; 
preset{end}.elec(:,:,1) = [7.07106781 11.3137085;9.28431204 11.3137085;11.3137085 9.28431204;11.3137085 7.07106781;7.07106781 11.3137085];
preset{end}.elec(:,:,2) = [-11.3137085 7.07106781;-11.3137085 9.28431204;-9.28431204 11.3137085;-7.07106781 11.3137085;-11.3137085 7.07106781];
preset{end}.elec(:,:,3) = [-7.07106781 -11.3137085;-9.28431204 -11.3137085;-11.3137085 -9.28431204;-11.3137085 -7.07106781;-7.07106781 -11.3137085];
preset{end}.elec(:,:,4) = [11.3137085 -7.07106781;11.3137085 -9.28431204;9.28431204 -11.3137085;7.07106781 -11.3137085;11.3137085 -7.07106781];
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 600; 
preset{end}.refinement = [true true false true]; 
preset{end}.hmin = 0.05; 
preset{end}.hmax = 0.4; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [5 5];
preset{end}.roi_poly_sum_xy = [5 5];
preset{end}.roi_poly_Q_xy = [5 5];
preset{end}.step_dos_xy = 0.5; 
preset{end}.step_poly_xy = 0.5; 
preset{end}.poly_powers = [5 3 7];


preset{end+1}.machine_name = 'Sirius';
preset{end}.pickup_name = '14 ILSF-1'; 
preset{end}.pickup_comment = ''; 
preset{end}.model_saved = '';
preset{end}.beampipe_type = 'Polygonal';
preset{end}.electrode_type = 'Polygon';
preset{end}.electrode_amount = 4;
preset{end}.body = [0 13;0.16564683 12.99894462;0.33129366 12.99577795;0.4969405 12.99049846;0.66258733 12.98310356;0.82823416 12.97358964;0.99388099 12.96195204;1.15952783 12.94818502;1.32517466 12.93228178;1.49082149 12.91423444;1.65646832 12.894034;1.82211515 12.8716703;1.98776199 12.84713206;2.15340882 12.8204068;2.31905565 12.79148079;2.48470248 12.76033909;2.65034932 12.72696541;2.81599615 12.69134216;2.98164298 12.65345033;3.14728981 12.61326947;3.31293665 12.57077765;3.47858348 12.52595134;3.64423031 12.47876538;3.80987714 12.4291929;3.97552397 12.37720522;4.14117081 12.32277178;4.30681764 12.26586001;4.47246447 12.20643525;4.6381113 12.14446061;4.80375814 12.07989684;4.96940497 12.01270221;5.1350518 11.94283229;5.30069863 11.87023985;5.46634546 11.79487462;5.6319923 11.7166831;5.79763913 11.6356083;5.96328596 11.55158952;6.12893279 11.46456204;6.29457963 11.37445679;6.37809187 11.32783934;6.9649905 11.91473797;7.20995395 11.66977452;8.72075865 11.66977452;9.00360136 11.95261723;11.95261723 9.00360136;11.66977452 8.72075865;11.66977452 7.20995395;11.91473797 6.9649905;11.32783934 6.37809187;11.3745 6.2946;11.4646 6.1289;11.5516 5.9633;11.6356 5.7976;11.7167 5.6320;11.7949 5.4663;11.8702 5.3007;11.9428 5.1351;12.0127 4.9694;12.0799 4.8038;12.1445 4.6381;12.2064 4.4725;12.2659 4.3068;12.3228 4.1412;12.3772 3.9755;12.4292 3.8099;12.4788 3.6442;12.5260 3.4786;12.5708 3.3129;12.6133 3.1473;12.6535 2.9816;12.6913 2.8160;12.7270 2.6503;12.7603 2.4847;12.7915 2.3191;12.8204 2.1534;12.8471 1.9878;12.8717 1.8221;12.8940 1.6565;12.9142 1.4908;12.9323 1.3252;12.9482 1.1595;12.9620 0.9939;12.9736 0.8282;12.9831 0.6626;12.9905 0.4969;12.9958 0.3313;12.9989 0.1656;13 0;12.9989 -0.1656;12.9958 -0.3313;12.9905 -0.4969;12.9831 -0.6626;12.9736 -0.8282;12.9620 -0.9939;12.9482 -1.1595;12.9323 -1.3252;12.9142 -1.4908;12.8940 -1.6565;12.8717 -1.8221;12.8471 -1.9878;12.8204 -2.1534;12.7915 -2.3191;12.7603 -2.4847;12.7270 -2.6503;12.6913 -2.8160;12.6535 -2.9816;12.6133 -3.1473;12.5708 -3.3129;12.5260 -3.4786;12.4788 -3.6442;12.4292 -3.8099;12.3772 -3.9755;12.3228 -4.1412;12.2659 -4.3068;12.2064 -4.4725;12.1445 -4.6381;12.0799 -4.8038;12.0127 -4.9694;11.9428 -5.1351;11.8702 -5.3007;11.7949 -5.4663;11.7167 -5.6320;11.6356 -5.7976;11.5516 -5.9633;11.4646 -6.1289;11.3745 -6.2946;11.32783934 -6.37809187;11.91473797 -6.9649905;11.66977452 -8.72075865;11.95261723 -9.00360136;9.00360136 -11.95261723;8.72075865 -11.66977452;7.20995395 -11.66977452;6.9649905 -11.91473797;6.37809187 -11.32783934;6.2946 -11.3745;6.1289 -11.4646;5.9633 -11.5516;5.7976 -11.6356;5.6320 -11.7167;5.4663 -11.7949;5.3007 -11.8702;5.1351 -11.9428;4.9694 -12.0127;4.8038 -12.0799;4.6381 -12.1445;4.4725 -12.2064;4.3068 -12.2659;4.1412 -12.3228;3.9755 -12.3772;3.8099 -12.4292;3.6442 -12.4788;3.4786 -12.5260;3.3129 -12.5708;3.1473 -12.6133;2.9816 -12.6535;2.8160 -12.6913;2.6503 -12.7270;2.4847 -12.7603;2.3191 -12.7915;2.1534 -12.8204;1.9878 -12.8471;1.8221 -12.8717;1.6565 -12.8940;1.4908 -12.9142;1.3252 -12.9323;1.1595 -12.9482;0.9939 -12.9620;0.8282 -12.9736;0.6626 -12.9831;0.4969 -12.9905;0.3313 -12.9958;0.1656 -12.9989;0 -13;-0.1656 -12.9989;-0.3313 -12.9958;-0.4969 -12.9905;-0.6626 -12.9831;-0.8282 -12.9736;-0.9939 -12.9620;-1.1595 -12.9482;-1.3252 -12.9323;-1.4908 -12.9142;-1.6565 -12.8940;-1.8221 -12.8717;-1.9878 -12.8471;-2.1534 -12.8204;-2.3191 -12.7915;-2.4847 -12.7603;-2.6503 -12.7270;-2.8160 -12.6913;-2.9816 -12.6535;-3.1473 -12.6133;-3.3129 -12.5708;-3.4786 -12.5260;-3.6442 -12.4788;-3.8099 -12.4292;-3.9755 -12.3772;-4.1412 -12.3228;-4.3068 -12.2659;-4.4725 -12.2064;-4.6381 -12.1445;-4.8038 -12.0799;-4.9694 -12.0127;-5.1351 -11.9428;-5.3007 -11.8702;-5.4663 -11.7949;-5.6320 -11.7167;-5.7976 -11.6356;-5.9633 -11.5516;-6.1289 -11.4646;-6.2946 -11.3745;-6.37809187 -11.32783934;-6.9649905 -11.91473797;-7.20995395 -11.66977452;-8.72075865 -11.66977452;-9.00360136 -11.95261723;-11.95261723 -9.00360136;-11.66977452 -8.72075865;-11.66977452 -7.20995395;-11.91473797 -6.9649905;-11.32783934 -6.37809187;-11.3745 -6.2946;-11.4646 -6.1289;-11.5516 -5.9633;-11.6356 -5.7976;-11.7167 -5.6320;-11.7949 -5.4663;-11.8702 -5.3007;-11.9428 -5.1351;-12.0127 -4.9694;-12.0799 -4.8038;-12.1445 -4.6381;-12.2064 -4.4725;-12.2659 -4.3068;-12.3228 -4.1412;-12.3772 -3.9755;-12.4292 -3.8099;-12.4788 -3.6442;-12.5260 -3.4786;-12.5708 -3.3129;-12.6133 -3.1473;-12.6535 -2.9816;-12.6913 -2.8160;-12.7270 -2.6503;-12.7603 -2.4847;-12.7915 -2.3191;-12.8204 -2.1534;-12.8471 -1.9878;-12.8717 -1.8221;-12.8940 -1.6565;-12.9142 -1.4908;-12.9323 -1.3252;-12.9482 -1.1595;-12.9620 -0.9939;-12.9736 -0.8282;-12.9831 -0.6626;-12.9905 -0.4969;-12.9958 -0.3313;-12.9989 -0.1656;-13 0;-12.9989 0.1656;-12.9958 0.3313;-12.9905 0.4969;-12.9831 0.6626;-12.9736 0.8282;-12.9620 0.9939;-12.9482 1.1595;-12.9323 1.3252;-12.9142 1.4908;-12.8940 1.6565;-12.8717 1.8221;-12.8471 1.9878;-12.8204 2.1534;-12.7915 2.3191;-12.7603 2.4847;-12.7270 2.6503;-12.6913 2.8160;-12.6535 2.9816;-12.6133 3.1473;-12.5708 3.3129;-12.5260 3.4786;-12.4788 3.6442;-12.4292 3.8099;-12.3772 3.9755;-12.3228 4.1412;-12.2659 4.3068;-12.2064 4.4725;-12.1445 4.6381;-12.0799 4.8038;-12.0127 4.9694;-11.9428 5.1351;-11.8702 5.3007;-11.7949 5.4663;-11.7167 5.6320;-11.6356 5.7976;-11.5516 5.9633;-11.4646 6.1289;-11.3745 6.2946;-11.32783934 6.37809187;-11.91473797 6.9649905;-11.66977452 8.72075865;-11.95261723 9.00360136;-9.00360136 11.95261723;-8.72075865 11.66977452;-7.20995395 11.66977452;-6.9649905 11.91473797;-6.37809187 11.32783934;-6.2946 11.3745;-6.1289 11.4646;-5.9633 11.5516;-5.7976 11.6356;-5.6320 11.7167;-5.4663 11.7949;-5.3007 11.8702;-5.1351 11.9428;-4.9694 12.0127;-4.8038 12.0799;-4.6381 12.1445;-4.4725 12.2064;-4.3068 12.2659;-4.1412 12.3228;-3.9755 12.3772;-3.8099 12.4292;-3.6442 12.4788;-3.4786 12.5260;-3.3129 12.5708;-3.1473 12.6133;-2.9816 12.6535;-2.8160 12.6913;-2.6503 12.7270;-2.4847 12.7603;-2.3191 12.7915;-2.1534 12.8204;-1.9878 12.8471;-1.8221 12.8717;-1.6565 12.8940;-1.4908 12.9142;-1.3252 12.9323;-1.1595 12.9482;-0.9939 12.9620;-0.8282 12.9736;-0.6626 12.9831;-0.4969 12.9905;-0.3313 12.9958;-0.1656 12.9989;0 13]; 
preset{end}.elec(:,:,1) = [6.96500179 11.41977452;9.25360136 11.41977452;11.41977452 9.25360136;11.41977452 6.96500179;6.96500179 11.41977452];
preset{end}.elec(:,:,2) = [-11.41977452 6.96500179;-11.41977452 9.25360136;-9.25360136 11.41977452;-6.96500179 11.41977452;-11.41977452 6.96500179];
preset{end}.elec(:,:,3) = [-6.96500179 -11.41977452;-9.25360136 -11.41977452;-11.41977452 -9.25360136;-11.41977452 -6.96500179;-6.96500179 -11.41977452];
preset{end}.elec(:,:,4) = [11.41977452 -6.96500179;11.41977452 -9.25360136;9.25360136 -11.41977452;6.96500179 -11.41977452;11.41977452 -6.96500179];
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 600; 
preset{end}.refinement = [true true false true]; 
preset{end}.hmin = 0.05; 
preset{end}.hmax = 0.4; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
preset{end}.roi_dos_xy = [2 2];
preset{end}.roi_poly_xy = [5 5];
preset{end}.roi_poly_sum_xy = [5 5];
preset{end}.roi_poly_Q_xy = [5 5];
preset{end}.step_dos_xy = 0.5; 
preset{end}.step_poly_xy = 0.5; 
preset{end}.poly_powers = [5 3 7];


preset{end+1}.machine_name = 'KIT';
preset{end}.pickup_name = 'C-Start';
preset{end}.pickup_comment = 'high energy acceptance storage ring'; 
preset{end}.model_saved = 'mesh-kit-cstart.mat'; 
preset{end}.beampipe_type = 'Circular';
preset{end}.electrode_type = 'Concave';
preset{end}.electrode_amount = 4;
preset{end}.R = 56.3/2;
preset{end}.input_by = 'electrode width'; 
preset{end}.aorie_deg = 45+[0 90 180 270]; 
preset{end}.aspan_deg = [1 1 1 1]; 
preset{end}.ewidth = 10.8*[1 1 1 1]; 
preset{end}.ethick = 2.5*[1 1 1 1]; 
preset{end}.gapback = 0.25*[1 1 1 1]; 
preset{end}.gapside = 0.25*[1 1 1 1]; 
preset{end}.symmetry = '4-fold'; 
preset{end}.mesh_gen_ttl = 360; 
preset{end}.hmin = 0.05;
preset{end}.hmax = 0.8; 
preset{end}.abcd_treatments = {'delta/sum (4 electrodes)', '20log10 (4 electrodes)', 'delta/sum (diagonal)', 'delta/sum (2 electrodes)', '20log10 (2 electrodes)'}; 
