function dos = dosU(dos_treatment, unodes)
% Version : BpmLab v1.16
% Date : Dec 04, 2018
% Author : Andriy Nosych

    electrode_amount = size(unodes,3); 

    for a = 1:electrode_amount
        u{a} = unodes(:,:,a); 
    end

    if electrode_amount == 2
        
        switch dos_treatment

            case 'delta/sum (2 electrodes)'

                dos{1} = (u{1}-u{2})./(u{1}+u{2}); 
                %dosy = ones(size(dosx)); 
        
            case '20log10 (2 electrodes)'

                dos{1} = log10(u{1}./u{2}); 
                
        end

        
    elseif electrode_amount ==4
    
        switch dos_treatment

            case 'delta/sum (2 electrodes)'

                dos{1} = (u{1}-u{3})./(u{1}+u{3}); % h 
                dos{2} = (u{2}-u{4})./(u{2}+u{4}); % v
                
            case '20log10 (2 electrodes)'

                dos{1} = 20*log10(u{1}./u{3}); % h
                dos{2} = 20*log10(u{2}./u{4}); % v
                
            case '20log10 (4 electrodes)'
                
                dos{1} = 20*log10( (u{1}+u{4})./(u{2}+u{3}) ); % h
                dos{2} = 20*log10( (u{1}+u{2})./(u{3}+u{4}) ); % v
                
            case 'delta/sum (4 electrodes)'
                
                dos{1} = (u{1}+u{4} - u{2}-u{3})./(u{1}+u{2}+u{3}+u{4}); % h
                dos{2} = (u{1}+u{2} - u{3}-u{4})./(u{1}+u{2}+u{3}+u{4}); % v

            case 'delta/sum (diagonal)'

                dos{1} = 1/2 * ((u{1} - u{3})./(u{1} + u{3}) - (u{2} - u{4})./(u{2} + u{4})); % h
                dos{2} = 1/2 * ((u{1} - u{3})./(u{1} + u{3}) + (u{2} - u{4})./(u{2} + u{4})); % v
                
                
            case 'atanh_ESRF'
                
                %//- the algorithm is given by: (c.f. Joel Chavanne Feb 2002)
                %//- X = -0.0592 + 11.469 * atanh(1.3658 * Qh)
                %//- In the present case, the offset -0.0592 is not applied
                %//- because we suppose it is already included in the offset.
                %//- which has been determided experimentally.
                %//- However, we add the -0.0592 to X to calculate the Z with the
                %//- following formula: Z = 14.37 * (1+0.001452 * X * X).

                %//- Qh = ((a - c) / (a + c) + (d - b) / (d + b))/2;
                %//- Rv = ((a - d) / (a + d) + (b - c) / (b + c))/2;

                %//- Xb = 11.469 * atanh(1.3658 * Qh);
                %//- Xb2 = Xb - 0.0592;
                %//- Zb = 14.37 * (1 + 0.001452 *(Xb2) * (Xb2)) * Rv;

                %double Qh = ((_dd_data.va_[i] - _dd_data.vc_[i]) / (_dd_data.va_[i] + _dd_data.vc_[i]) + 
                %             (_dd_data.vd_[i] - _dd_data.vb_[i]) / (_dd_data.vd_[i] + _dd_data.vb_[i])) / 2.0;

                %double Rv = ((_dd_data.va_[i] - _dd_data.vd_[i]) / (_dd_data.va_[i] + _dd_data.vd_[i]) +
                %             (_dd_data.vb_[i] - _dd_data.vc_[i]) / (_dd_data.vb_[i] + _dd_data.vc_[i])) / 2.0;

                %_dd_data.x_[i] = 11.469 * atanh(1.3658 * Qh);
                %double Xb2  = _dd_data.x_[i] - 0.0592;
                %_dd_data.x_[i] = _dd_data.x_[i] OFFSETS_SIGN _config.Xoffset_local;

                %_dd_data.z_[i] = 14.37 * (1 + 0.001452 * Xb2 * Xb2) * Rv; 
                %_dd_data.z_[i] = _dd_data.z_[i] OFFSETS_SIGN _config.Zoffset_local;
                
                Qh = ((u{1} - u{3})./(u{1} + u{3}) + (u{4} - u{2})./(u{4} + u{2}))/2;
                Rv = ((u{1} - u{4})./(u{1} + u{4}) + (u{2} - u{3})./(u{2} + u{3}))/2;
                
                dos{1} = atanh(1.3658 * Qh);
                Xb2  = dos{1} - 0.0592;
                dos{2} = (1 + 0.001452 * Xb2.*Xb2) .* Rv;
                %dos{1} = 11.469 * atanh(1.3658 * Qh);
                %Xb2  = dosx - 0.0592;
                %dos{2} = 14.37 * (1 + 0.001452 * Xb2.*Xb2) .* Rv;

                
        end
    end
end
