% https://es.mathworks.com/matlabcentral/answers/380395-how-can-i-move-a-point-a-known-distance-in-the-direction-of-another-point-in-3d
% https://math.stackexchange.com/questions/175896/finding-a-point-along-a-line-a-certain-distance-away-from-another-point

ofst = 0.3

% small EBS-BPM
A = [3.3045	6.182732] 
B = [5.206282	10.261117]
bodyA = [3.3045	6.182732; 5.206282	10.261117; 11.097282	7.514098; 9.1955	3.435713]
e0 = [3.531077     6.077077; 5.221550     9.702309; 10.659396     7.166599; 8.968923     3.541368; 3.531077     6.077077]; 

% large EBS-BPM
%A = [8.2443       9.3998] 
%B = [11.137       12.847]
%bodyA = [8.2443       9.3998;
%       11.137       12.847;
%       17.648       7.3833;
%       14.756       3.9361]
%e0 = [8.435822	9.239096; 11.006973	12.303274; 17.135328	7.160973; 14.564178	4.096795; 8.435822	9.239096]; 

% ===

AB  = B - A
nAB = AB ./ sqrt(sum(AB .^ 2, 2))

e1 = bsxfun(@plus,e0,ofst * nAB)


% d0 = sqrt( (a0(1)-b0(1))^2 + (a0(2)-b0(2))^2)
% d1 = sqrt( (x1(1,1)-x1(2,1))^2 + (x1(1,2)-x1(2,2))^2)



figure(), hold on
plot(bodyA(:,1), bodyA(:,2),'-ko')
plot(e0(:,1), e0(:,2),'-bd')
plot(e1(:,1), e1(:,2),'--r.')

axis image
box on

d = sqrt( (e0(1,1)-e1(1,1))^2 + (e0(1,2)-e1(1,2))^2)