function [x,y] = ellipse(varargin)
% Author: Andrew Schwartz
% Harvard/MIT SHBT program
% Version 1.0.2, 11/22/2009

    %parse x,y,rx,ry
    if length(varargin)<3, error('Not enough input arguments'); end
    if length(varargin)==3, varargin{4} = varargin{3}; end
    [x y rx ry] = deal(varargin{1:4});
    varargin(1:4) = [];

    %ellipse tilt in radians, deafult 0
    t = 0;
    if ~isempty(varargin) && isnumeric(varargin{1})
        t = varargin{1};
        varargin(1)=[];
    end

    %Number of points, arc start*end angles (in radians)
    N = 100;        %default: 100 points
    th = [0 2*pi];  %default: full ellipse
    while ~isempty(varargin) && isnumeric(varargin{1})
        a = varargin{1};
        if length(a)==1
            N = a;
        else
            th = a;
        end
        varargin(1) = [];
    end

    %distribute N points between arc start & end angles
    th = linspace(th(1),th(2),N);

    %calculate x and y points
    x = x + rx*cos(th)*cos(t) - ry*sin(th)*sin(t);
    y = y + rx*cos(th)*sin(t) + ry*sin(th)*cos(t);

end